/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.timecode;

import org.openimaj.video.timecode.VideoTimecode;

public class FrameNumberVideoTimecode
extends VideoTimecode {
    private long frameNumber = -1L;
    protected double fps = 0.0;

    public FrameNumberVideoTimecode(long number, double fps) {
        this.frameNumber = number;
        this.fps = fps;
    }

    @Override
    public long getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(long frame) {
        this.frameNumber = frame;
    }

    @Override
    public int compareTo(VideoTimecode o) {
        if (o instanceof FrameNumberVideoTimecode) {
            long diff = ((FrameNumberVideoTimecode)o).getFrameNumber() - this.frameNumber;
            if (diff == 0L) {
                return 0;
            }
            return diff < 0L ? 1 : -1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)this.frameNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FrameNumberVideoTimecode) {
            return this.frameNumber == ((FrameNumberVideoTimecode)obj).getFrameNumber();
        }
        return false;
    }

    public String toString() {
        return "Frame " + this.frameNumber;
    }

    @Override
    public long getTimecodeInMilliseconds() {
        return (long)((double)(this.frameNumber * 1000L) / this.fps);
    }

    @Override
    public void setTimecodeInMilliseconds(long timeInMilliseconds) {
        this.frameNumber = (long)((double)timeInMilliseconds * this.fps / 1000.0);
    }

    @Override
    public FrameNumberVideoTimecode clone() {
        return new FrameNumberVideoTimecode(this.frameNumber, this.fps);
    }
}

