/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.openimaj.util.processes.JavaProcess;
import uk.ac.soton.ecs.comp3204.utils.CompileUtils;

public abstract class BaseTool {
    private File compileDir = Files.createTempDirectory("comp3204hybridimages", new FileAttribute[0]).toFile();
    private boolean sandbox = true;
    private File policy;

    public BaseTool() throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                org.openimaj.io.FileUtils.deleteRecursive(BaseTool.this.compileDir);
            }
        });
        if (System.getProperty("hybridimages.sandbox.disable") != null) {
            System.err.println("Warning: sandboxing is disabled.");
            this.sandbox = false;
        } else {
            this.policy = new File(this.compileDir, "hybridimages.policy");
            org.openimaj.io.FileUtils.copyStreamToFile(BaseTool.class.getResourceAsStream("hybridimages.policy"), this.policy);
        }
    }

    protected JavaProcess.ProcessOptions prepareProcessOptions(Class<?> mainClass) {
        JavaProcess.ProcessOptions opts = new JavaProcess.ProcessOptions(mainClass);
        String sec = this.sandbox ? "-Djava.security.manager -Djava.security.policy=" + this.policy.getAbsolutePath() : "";
        opts.setJvmArgs(String.valueOf(sec) + " -Dclass.path=" + this.compileDir.getAbsolutePath() + " -Djava.system.class.loader=uk.ac.soton.ecs.comp3204.hybridimages.BlackListClassLoader");
        return opts;
    }

    protected String[] getClasses(File ... javaOrClassFiles) throws Exception {
        String[] clsName;
        if (javaOrClassFiles[0].getName().endsWith(".class")) {
            clsName = this.prepareClassFiles(javaOrClassFiles);
        } else if (javaOrClassFiles[0].getName().endsWith(".java")) {
            clsName = this.compileJavaFiles(javaOrClassFiles);
        } else {
            throw new RuntimeException("Unrecognised File Type (expected .java or .class)");
        }
        return clsName;
    }

    private String[] prepareClassFiles(File ... classFiles) throws Exception {
        String[] clsNames = new String[classFiles.length];
        int i = 0;
        File[] fileArray = classFiles;
        int n = classFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File classFile = fileArray[n2];
            Throwable throwable = null;
            Object var9_10 = null;
            try (FileInputStream stream = new FileInputStream(classFile);){
                ClassFile cf = new ClassFile();
                cf.read(stream);
                String clsName = cf.getFullClassName();
                String name = ClassFileUtils.convertDotName(clsName);
                File target = new File(this.compileDir, name);
                target.getParentFile().mkdirs();
                FileUtils.copyFile(classFile, target);
                clsNames[i] = clsName;
                ++i;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
        return clsNames;
    }

    private String[] compileJavaFiles(File ... javaFiles) throws IOException, Exception {
        String[] clsNames = new String[javaFiles.length];
        SimpleJavaFileObject[] files = new SimpleJavaFileObject[javaFiles.length];
        int i = 0;
        File[] fileArray = javaFiles;
        int n = javaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String clsName;
            File javaFile = fileArray[n2];
            String convImplData = org.openimaj.io.FileUtils.readall(javaFile);
            Pattern p = Pattern.compile("package\\s+([a-zA_Z_][\\.\\w]*);");
            Matcher m = p.matcher(convImplData);
            if (m.find()) {
                String pkg = m.group(1);
                clsName = String.valueOf(pkg) + "." + javaFile.getName().replace(".java", "");
            } else {
                clsName = javaFile.getName().replace(".java", "");
            }
            clsNames[i] = clsName;
            CompileUtils.InMemoryJavaFileObject file = new CompileUtils.InMemoryJavaFileObject(clsName, convImplData);
            files[i] = file;
            ++i;
            ++n2;
        }
        List<SimpleJavaFileObject> ifiles = Arrays.asList(files);
        boolean result = CompileUtils.compile(ifiles, this.compileDir);
        if (!result) {
            System.err.println("Compilation failed. Terminating.");
            System.exit(1);
        }
        return clsNames;
    }
}

