/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

public class BlackListClassLoader
extends URLClassLoader {
    private static List<String> blacklistedClasses = Arrays.asList("org.openimaj.image.processing.convolution.FConvolution", "org.openimaj.image.processing.convolution.FGaussianConvolve", "org.openimaj.image.processing.convolution.FFastGaussianConvolve", "org.openimaj.image.processing.convolution.FImageConvolveSeparable");

    public BlackListClassLoader(ClassLoader launcherClassLoader) {
        super(BlackListClassLoader.getUrls(launcherClassLoader), launcherClassLoader.getParent());
    }

    public static URL[] getUrls(ClassLoader cl) {
        String[] pathElements = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        URL[] base = new URL[pathElements.length];
        int i = 0;
        while (i < pathElements.length) {
            try {
                base[i] = new File(pathElements[i]).toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (System.getProperty("class.path") != null) {
            try {
                URL xtra;
                URL[] out = new URL[base.length + 1];
                System.arraycopy(base, 0, out, 0, base.length);
                out[base.length] = xtra = new File(System.getProperty("class.path")).toURI().toURL();
                return out;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return base;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String c : blacklistedClasses) {
            if (!name.startsWith(c)) continue;
            throw new ClassNotFoundException(String.valueOf(name) + " is blacklisted");
        }
        return super.loadClass(name, resolve);
    }
}

