/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.openimaj.OpenIMAJ;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.util.processes.JavaProcess;
import uk.ac.soton.ecs.comp3204.hybridimages.BaseTool;

public class SubmissionCheckerTool
extends BaseTool {
    @Argument(required=true, usage="path to MyConvolution.java", index=0, metaVar="path/to/MyConvolution.java")
    protected File convImpl;
    @Argument(required=true, usage="path to MyHybridImages.java", index=1, metaVar="path/to/MyHybridImages.java")
    protected File hybridImpl;

    protected void run() throws Exception {
        String[] clsNames = this.getClasses(this.convImpl, this.hybridImpl);
        JavaProcess.ProcessOptions op = this.prepareProcessOptions(TestingToolMain.class);
        op.setArgs(clsNames);
        JavaProcess.runProcess(op);
    }

    public static void main(String[] args) throws Exception {
        SubmissionCheckerTool ct = new SubmissionCheckerTool();
        CmdLineParser parser = new CmdLineParser(ct);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Usage: java -jar SubmissionChecker.jar path/to/MyConvolution.java path/to/MyHybridImages.java");
            parser.printUsage(System.err);
            return;
        }
        ct.run();
    }

    public static class TestingToolMain {
        public static void main(String[] args) {
            try {
                Class<?> convClz = Class.forName(args[0]);
                Constructor<?> constr = convClz.getConstructor(float[][].class);
                float[][] kernel = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
                SinglebandImageProcessor conv = (SinglebandImageProcessor)constr.newInstance(new Object[]{kernel});
                System.out.println("MyConvolution instance created successfully.");
                FImage test = ImageUtilities.readF(OpenIMAJ.getLogoAsStream());
                test.process(conv);
                System.out.println("MyConvolution successfully applied to image (Note that this doesn't mean that the code is correct; just that it runs!).");
                Class<?> hybridClz = Class.forName(args[1]);
                Method hybmeth = hybridClz.getDeclaredMethod("makeHybrid", MBFImage.class, Float.TYPE, MBFImage.class, Float.TYPE);
                MBFImage mtest = ImageUtilities.readMBF(OpenIMAJ.getLogoAsStream());
                MBFImage result = (MBFImage)hybmeth.invoke(null, mtest, Float.valueOf(1.0f), mtest, Float.valueOf(2.0f));
                if (result != null) {
                    System.out.println("MyHybridImages.makeHybrid successfully applied to image pair (Note that this doesn't mean that the code is correct; just that it runs!).");
                } else {
                    System.out.println("MyHybridImages.makeHybrid returned null! Please fix your implementation.");
                }
            }
            catch (Exception e) {
                System.out.println("An error occured running your code.");
                System.out.println("The stack trace below might help indicate why.");
                System.out.println("If you believe this is not because of an error on your part then please contact Jon.");
                System.out.println();
                e.printStackTrace(System.out);
            }
        }
    }
}

