/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages.bridge;

import com.jmatio.io.MatFileReader;
import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSingle;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandImageProcessor;

public abstract class ConvolutionBridge
implements SinglebandImageProcessor<Float, FImage> {
    public static final String CONVOLUTION_BRIDGE_SCRIPT = "convolution.bridge.script";
    private float[][] kernel;

    public ConvolutionBridge(float[][] kernel) {
        this.kernel = kernel;
    }

    public static FImage convert(MLArray arr) {
        FImage img = new FImage(arr.getN(), arr.getM());
        MLNumericArray mlarr = (MLNumericArray)arr;
        int i = 0;
        while (i < img.height) {
            int j = 0;
            while (j < img.width) {
                img.pixels[i][j] = ((Number)mlarr.get(i, j)).floatValue();
                ++j;
            }
            ++i;
        }
        return img;
    }

    public static MLArray convert(FImage img, String name) {
        MLSingle arr = new MLSingle(name, new int[]{img.height, img.width}, 7, 0);
        int i = 0;
        while (i < img.height) {
            int j = 0;
            while (j < img.width) {
                arr.set(Float.valueOf(img.pixels[i][j]), i, j);
                ++j;
            }
            ++i;
        }
        return arr;
    }

    @Override
    public void processImage(FImage image) {
        try {
            File scriptfile = new File(System.getProperty(CONVOLUTION_BRIDGE_SCRIPT));
            File baseDir = scriptfile.getParentFile();
            File inFile = new File(baseDir, "inputs.mat");
            File outFile = new File(baseDir, "output.mat");
            MatFileWriter writer = new MatFileWriter();
            ArrayList<MLArray> inputs = new ArrayList<MLArray>();
            inputs.add(ConvolutionBridge.convert(new FImage(this.kernel), "kernel"));
            inputs.add(ConvolutionBridge.convert(image, "image"));
            writer.write(inFile, inputs);
            this.perform(scriptfile, inFile, outFile);
            MatFileReader reader = new MatFileReader();
            Map<String, MLArray> outputs = reader.read(outFile);
            if (outputs.containsKey("error")) {
                MLChar res = (MLChar)outputs.get("error");
                String err = res.contentToString();
                throw new RuntimeException(err);
            }
            FImage tmp = ConvolutionBridge.convert(outputs.get("image"));
            image.internalAssign(tmp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void perform(File var1, File var2, File var3) throws Exception;
}

