/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages.bridge;

import com.mathworks.engine.EngineException;
import com.mathworks.engine.MatlabEngine;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.openimaj.io.FileUtils;
import uk.ac.soton.ecs.comp3204.hybridimages.bridge.ConvolutionBridge;

public class MatlabEngineConvolutionBridge
extends ConvolutionBridge {
    protected static MatlabEngine matlab;

    public static void addLibraryPath(String pathToAdd) throws Exception {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        String[] stringArray = paths = (String[])usrPathsField.get(null);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.equals(pathToAdd)) {
                return;
            }
            ++n2;
        }
        String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
        newPaths[newPaths.length - 1] = pathToAdd;
        usrPathsField.set(null, newPaths);
    }

    public MatlabEngineConvolutionBridge(float[][] kernel) {
        super(kernel);
        try {
            if (matlab == null) {
                MatlabEngineConvolutionBridge.addLibraryPath("/Applications/MATLAB_R2018b.app/bin/maci64");
                matlab = MatlabEngine.startMatlab();
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            matlab.close();
                        }
                        catch (EngineException engineException) {
                            // empty catch block
                        }
                    }
                }));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void perform(File script, File inFile, File outFile) throws Exception {
        FileUtils.copyStreamToFile(MatlabEngineConvolutionBridge.class.getResourceAsStream("matlab/ConvolutionBridge.m"), new File(script.getParent(), "convbridge.m"));
        matlab.eval("clear");
        matlab.eval("cd " + script.getParent());
        matlab.eval("convbridge");
    }
}

