/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages.bridge;

import com.jmatio.io.MatFileReader;
import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSingle;
import com.mathworks.engine.MatlabEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.io.FileUtils;
import uk.ac.soton.ecs.comp3204.hybridimages.bridge.MatlabEngineConvolutionBridge;

public class MatlabEngineHybridBridge {
    public static final String HYBRID_BRIDGE_SCRIPT = "hybrid.bridge.script";
    static MatlabEngine matlab;

    static {
        new MatlabEngineConvolutionBridge(null);
        matlab = MatlabEngineConvolutionBridge.matlab;
    }

    public static MBFImage convert(MLArray arr) {
        int[] dims = arr.getDimensions();
        MBFImage img = new MBFImage(dims[1], dims[0]);
        MLNumericArray mlarr = (MLNumericArray)arr;
        int height = img.getHeight();
        int width = img.getWidth();
        int b = 0;
        while (b < 3) {
            float[][] pixels = ((FImage)img.getBand((int)b)).pixels;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int idx = i + j * height + b * height * width;
                    pixels[i][j] = ((Number)mlarr.get(idx)).floatValue();
                    ++j;
                }
                ++i;
            }
            ++b;
        }
        return img;
    }

    public static MLArray convert(MBFImage img, String name) {
        int height = img.getHeight();
        int width = img.getWidth();
        MLSingle arr = new MLSingle(name, new int[]{height, width, 3}, 7, 0);
        int b = 0;
        while (b < 3) {
            float[][] pixels = ((FImage)img.getBand((int)b)).pixels;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int idx = i + j * height + b * height * width;
                    arr.set(Float.valueOf(pixels[i][j]), idx);
                    ++j;
                }
                ++i;
            }
            ++b;
        }
        return arr;
    }

    public static MLArray convert(float d, String name) {
        return new MLSingle(name, new Float[]{Float.valueOf(d)}, 1);
    }

    public static MBFImage makeHybrid(MBFImage image1, float sigma1, MBFImage image2, float sigma2) {
        try {
            File scriptfile = new File(System.getProperty(HYBRID_BRIDGE_SCRIPT));
            File baseDir = scriptfile.getParentFile();
            File inFile = new File(baseDir, "inputs.mat");
            File outFile = new File(baseDir, "output.mat");
            MatFileWriter writer = new MatFileWriter();
            ArrayList<MLArray> inputs = new ArrayList<MLArray>();
            inputs.add(MatlabEngineHybridBridge.convert(image1, "image1"));
            inputs.add(MatlabEngineHybridBridge.convert(sigma1, "sigma1"));
            inputs.add(MatlabEngineHybridBridge.convert(image2, "image2"));
            inputs.add(MatlabEngineHybridBridge.convert(sigma2, "sigma2"));
            writer.write(inFile, inputs);
            FileUtils.copyStreamToFile(MatlabEngineHybridBridge.class.getResourceAsStream("matlab/HybridBridge.m"), new File(scriptfile.getParent(), "hybrbridge.m"));
            matlab.eval("clear");
            matlab.eval("cd " + scriptfile.getParent());
            matlab.eval("hybrbridge");
            MatFileReader reader = new MatFileReader();
            Map<String, MLArray> outputs = reader.read(outFile);
            if (outputs.containsKey("error")) {
                MLChar res = (MLChar)outputs.get("error");
                String err = res.contentToString();
                throw new RuntimeException(err);
            }
            return MatlabEngineHybridBridge.convert(outputs.get("image"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

