/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.hybridimages.bridge;

import com.jmatio.io.MatFileReader;
import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLSingle;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.io.FileUtils;

public class PythonHybridBridge {
    public static final String HYBRID_BRIDGE_SCRIPT = "hybrid.bridge.script";

    public static MBFImage convert(MLArray arr) {
        int[] dims = arr.getDimensions();
        MBFImage img = new MBFImage(dims[1], dims[0]);
        MLNumericArray mlarr = (MLNumericArray)arr;
        int height = img.getHeight();
        int width = img.getWidth();
        int b = 0;
        while (b < 3) {
            float[][] pixels = ((FImage)img.getBand((int)b)).pixels;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int idx = i + j * height + b * height * width;
                    pixels[i][j] = ((Number)mlarr.get(idx)).floatValue();
                    ++j;
                }
                ++i;
            }
            ++b;
        }
        return img;
    }

    public static MLArray convert(MBFImage img, String name) {
        int height = img.getHeight();
        int width = img.getWidth();
        MLSingle arr = new MLSingle(name, new int[]{height, width, 3}, 7, 0);
        int b = 0;
        while (b < 3) {
            float[][] pixels = ((FImage)img.getBand((int)b)).pixels;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int idx = i + j * height + b * height * width;
                    arr.set(Float.valueOf(pixels[i][j]), idx);
                    ++j;
                }
                ++i;
            }
            ++b;
        }
        return arr;
    }

    public static MLArray convert(float d, String name) {
        return new MLSingle(name, new Float[]{Float.valueOf(d)}, 1);
    }

    public static MBFImage makeHybrid(MBFImage image1, float sigma1, MBFImage image2, float sigma2) {
        try {
            File scriptfile = new File(System.getProperty(HYBRID_BRIDGE_SCRIPT));
            File baseDir = scriptfile.getParentFile();
            File inFile = new File(baseDir, "inputs.mat");
            File outFile = new File(baseDir, "output.mat");
            MatFileWriter writer = new MatFileWriter();
            ArrayList<MLArray> inputs = new ArrayList<MLArray>();
            inputs.add(PythonHybridBridge.convert(image1, "image1"));
            inputs.add(PythonHybridBridge.convert(sigma1, "sigma1"));
            inputs.add(PythonHybridBridge.convert(image2, "image2"));
            inputs.add(PythonHybridBridge.convert(sigma2, "sigma2"));
            writer.write(inFile, inputs);
            String python = System.getProperty("python.path", "/Applications/anaconda3/bin/python");
            FileUtils.copyStreamToFile(PythonHybridBridge.class.getResourceAsStream("python/HybridBridge.py"), new File(scriptfile.getParent(), "hybrbridge.py"));
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.inheritIO();
            pb.directory(scriptfile.getParentFile());
            pb.command(python, "hybrbridge.py", inFile.getAbsolutePath(), outFile.getAbsolutePath());
            Process p = pb.start();
            p.waitFor();
            MatFileReader reader = new MatFileReader();
            Map<String, MLArray> outputs = reader.read(outFile);
            if (outputs.containsKey("error")) {
                MLChar res = (MLChar)outputs.get("error");
                String err = res.contentToString();
                throw new RuntimeException(err);
            }
            return PythonHybridBridge.convert(outputs.get("image"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

