/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.ecs.comp3204.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompileUtils {
    public static boolean compile(Iterable<? extends JavaFileObject> files, File classOutputFolder) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            System.err.println("No java compiler available. Are you using a JRE install rather than a JDK?");
            System.exit(-1);
        }
        MyDiagnosticListener c = new MyDiagnosticListener();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(c, Locale.ENGLISH, null);
        List<String> options = Arrays.asList("-d", classOutputFolder.getAbsolutePath());
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, c, options, null, files);
        Boolean result = task.call();
        return result;
    }

    public static class InMemoryJavaFileObject
    extends SimpleJavaFileObject {
        private String contents = null;

        public InMemoryJavaFileObject(String className, String contents) throws Exception {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.contents = contents;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.contents;
        }
    }

    public static class MyDiagnosticListener
    implements DiagnosticListener<JavaFileObject> {
        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            System.out.println("Line Number->" + diagnostic.getLineNumber());
            System.out.println("code->" + diagnostic.getCode());
            System.out.println("Message->" + diagnostic.getMessage(Locale.ENGLISH));
            System.out.println("Source->" + diagnostic.getSource());
            System.out.println(" ");
        }
    }

    public static class OnDiskJavaFileObject
    extends SimpleJavaFileObject {
        public OnDiskJavaFileObject(File path) throws Exception {
            super(path.toURI(), JavaFileObject.Kind.SOURCE);
        }
    }
}

