function convolved=myconvolution(image, kernel)
% MYCONVOLUTION  Convolve an image with a kernel
%   C = MYCONVOLUTION(image,kernel) returns the two-dimensional convolution 
%       of matrices image and kernel assuming zero-padding of the image to handle the borders.
%   
%   image should have size (rows,cols) or (rows,cols,channels)
%   kernel should have size (krows,kcols); both dimensions odd

	kernel = flipud(fliplr(kernel));
	
	dims = size(image);
	if size(dims)[1] == 3
		channels = size(image, 3);
		convolved = zeros(size(image));
		for c=1:channels
			convolved(:,:,c) = mycorr_channel(image(:,:,c), kernel);
		end
	else
	 	convolved = mycorr_channel(image, kernel);		
	end
end


function convolved=mycorr_channel(image, kernel)
	[imheight, imwidth] = size(image);
	[kh, kw] = size(kernel);
	hh = floor(kh/2);
	hw = floor(kw/2);
	convolved = zeros(size(image));
	pad = zeros(imheight+hh*2, imwidth+hw*2);
	[ph, pw] = size(pad);
	pad(hh+1:ph-hh, hw+1:pw-hw) = image;
	for j = 1:imheight
		for i = 1:imwidth
%			convolved(j,i) = sum(sum(kernel.*pad(j:j+kh-1,i:i+kw-1)));
			for jj = 1:kh
				for ii = 1:kw
					convolved(j,i) = convolved(j,i) + kernel(jj, ii) * pad(j + jj - 1, i + ii - 1);
				end
			end
		end
	end
end
