function convolved=myconvolution(image, kernel)
% MYCONVOLUTION  Convolve an image with a kernel
%   C = MYCONVOLUTION(image,kernel) returns the two-dimensional convolution 
%       of matrices image and kernel assuming zero-padding of the image to handle the borders.
%   
%   image should have size (rows,cols) or (rows,cols,channels)
%   kernel should have size (krows,kcols); both dimensions odd

	kernel = flipud(fliplr(kernel));
	
	dims = size(image);
	if size(dims)[1] == 3
		channels = size(image, 3);
		convolved = zeros(size(image));
		for c=1:channels
			convolved(:,:,c) = mycorr_channel(image(:,:,c), kernel);
		end
	else
	 	convolved = mycorr_channel(image, kernel);		
	end
end


function convolved=mycorr_channel(image, kernel)
	[imheight, imwidth] = size(image);
	[kh, kw] = size(kernel);
	hh = floor(kh/2);
	hw = floor(kw/2);
	convolved = zeros(size(image));
	for j = hh+1:imheight-hh
		for i = hw+1:imwidth-hw
			for jj = 1:kh
				for ii = 1:kw
					convolved(j,i) = convolved(j,i) + kernel(jj, ii) * image(j + jj - 1 - hh, i + ii - 1 - hw);
				end
			end
		end
	end
end
