import numpy as np


def convolve(image: np.ndarray, kernel: np.ndarray) -> np.ndarray:
	"""
	Convolve an image with a kernel assuming zero-padding of the image to handle the borders
	
	:param image: the image (either greyscale shape=(rows,cols) or colour shape=(rows,cols,channels))
	:type numpy.ndarray
	
	:param kernel: the kernel (shape=(kheight,kwidth); both dimensions odd)
	:type numpy.ndarray 
	
	:returns the convolved image (of the same shape as the input image)
	:rtype numpy.ndarray
	"""
	if image.ndim == 2:
		return corr_channel(image, kernel)
	else:
		out = np.zeros_like(image)
		for c in range(image.shape[2]):
			out[:,:,c] = corr_channel(image[:,:,c], kernel)
		return out


def corr_channel(image: np.ndarray, kernel: np.ndarray) -> np.ndarray:	
	halfHeight = kernel.shape[0] // 2
	halfWidth = kernel.shape[1] // 2
	
	output = np.zeros_like(image)

	for y in range(halfHeight, image.shape[0]-halfHeight):
		for x in range(halfWidth, image.shape[1]-halfWidth):
			output[y,x]=(kernel*image[y-halfHeight:y+kernel.shape[0]-halfHeight, x-halfWidth:x+kernel.shape[1]-halfWidth]).sum()
			 			        
	return output
	
