function hybrid=myhybridimages(lowImage, lowSigma, highImage, highSigma)
	% MYHYBRIDIMAGES  Create hybrid images by combining a low-pass and high-pass filtered pair.
	%   C = MYHYBRIDIMAGES(lowImage, lowSigma, highImage, highSigma) returns the hybrid image created
	%       by low-pass filtering lowImage with a Gaussian of s.d. lowSigma and combining it with 
	%       a high-pass image created by subtracting highImage from highImage convolved with
	%       a Gaussian of s.d. highSigma
	%   
	%   lowImage and highImage should both have size (rows,cols) or (rows,cols,channels). 
	%   The resultant image also has the same size
	
end

function f=makegaussiankernel(sigma)
	% Use this function to create a 2D gaussian kernel with standard deviation sigma.
	% The kernel values should sum to 1.0, and the size should be floor(8*sigma+1) or 
	% floor(8*sigma+1)+1 (whichever is odd) as per the assignment specification.
	
end
